<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->index();
            $table->string('phone')->unique();
            $table->string('business_phone')->nullable();
            $table->string('email')->nullable();
            $table->enum('gender',['male', 'female'])->default('male');
            $table->BigInteger('country_id')->index();
            $table->BigInteger('city_id')->index();
            $table->BigInteger('region_id')->index();
            $table->date('birth_date')->nullable();
            $table->BigInteger('otp')->nullable();
            $table->enum('role',['admin', 'student', 'trainer'])->default('student');
            $table->timestamp('phone_verified_at')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->boolean('active')->default(1);
            $table->string('device_token')->nullable();
            $table->string('profile_id')->nullable();
            $table->string('provide_name')->nullable();
            $table->string('logo')->nullable();
            $table->integer('student_points')->nullable();
            $table->softDeletes();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
