<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrainingsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trainings', function (Blueprint $table) {
            $table->id('id');
            $table->BigInteger('user_id');
            $table->BigInteger('training_type_id');
            $table->BigInteger('type_level_id');
            $table->BigInteger('level_category_id')->nullable();
            $table->BigInteger('question_type_id');
            $table->string('question_speed')->nullable();
            $table->integer('training_period');
            $table->integer('numbers_count');
            $table->integer('questions_count');
            $table->string('answer_type');
            $table->integer('correct_answers_count')->nullable();
            $table->integer('wrong_answers_count')->nullable();
            $table->string('answering_period')->nullable();
            $table->integer('student_points')->nullable();
            $table->boolean('active')->default(1);
            $table->boolean('finish')->default(0);
            $table->boolean('student_points_is_collected')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('trainings');
    }
}
