<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompetitionsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('competitions', function (Blueprint $table) {
            $table->id();
            $table->BigInteger('user_id');
            $table->BigInteger('type_level_id');
            $table->BigInteger('level_category_id')->nullable();
            $table->BigInteger('question_type_id');
            $table->text('competition_datetime');
            $table->string('question_speed');
            $table->integer('training_period');
            $table->integer('numbers_count');
            $table->integer('questions_count');
            $table->string('answer_type');
            $table->boolean('active')->default(1);
            $table->boolean('finish')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('competitions');
    }
}
