<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrainerMessagesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trainer_messages', function (Blueprint $table) {
            $table->id('id');
            $table->BigInteger('student_id');
            $table->BigInteger('trainer_id');
            $table->text('message');
            $table->enum('sender_type',['student', 'trainer'])->default('student');
            $table->boolean('active')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('trainer_messages');
    }
}
