<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up() {
		Schema::create('contacts', function (Blueprint $table) {
			$table->id();
			$table->string('full_name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->longText('message')->nullable();
            $table->enum('type',['student', 'trainer'])->default('student');
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down() {
		Schema::drop('contacts');
	}
}
