<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrainerRegionsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trainer_regions', function (Blueprint $table) {
            $table->id('id');
            $table->BigInteger('user_id');
            $table->BigInteger('country_id');
            $table->BigInteger('city_id');
            $table->BigInteger('region_id');
            $table->string('address');
            $table->string('lat');
            $table->string('lng');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('trainer_regions');
    }
}
