<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChampionshipsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('championships', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->text('slogan')->nullable();
            $table->enum('type',['general', 'special'])->default('general');
            $table->double('price')->default(0);
            $table->boolean('active')->default(1);
            $table->boolean('finish')->default(0);
            $table->timestamp('start_at');
            $table->integer('training_period');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('championships');
    }
}
