<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChampionshipSubscribersTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('championship_subscribers', function (Blueprint $table) {
            $table->id('id');
            $table->BigInteger('championship_id');
            $table->BigInteger('type_level_id');
            $table->BigInteger('age_category_id');
            $table->BigInteger('user_id');
            $table->integer('correct_answers_count')->nullable();
            $table->integer('wrong_answers_count')->nullable();
            $table->string('answering_period')->nullable();
            $table->integer('student_points')->nullable();
            $table->boolean('active')->default(0);
            $table->boolean('finish')->default(0);
            $table->boolean('student_points_is_collected')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('championship_subscribers');
    }
}
